<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

	  const Err1 = "Security error: Call to private object member not allowed";
	  const Err2 = "Security error: Call to dynamic object member not allowed";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
				if ($this->security = isset($this->smarty->security_policy)) {
              $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
              $this->php_handling = $this->smarty->php_handling;
        }
				$this->is_xml = false;
				$this->asp_tags = (ini_get('asp_tags') != '0');
				$this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       return '?<?php ?>>';
    }

    
#line 121 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_OTHER                          = 10;
    const TP_LINEBREAK                      = 11;
    const TP_LITERALSTART                   = 12;
    const TP_LITERALEND                     = 13;
    const TP_LITERAL                        = 14;
    const TP_LDEL                           = 15;
    const TP_RDEL                           = 16;
    const TP_DOLLAR                         = 17;
    const TP_ID                             = 18;
    const TP_EQUAL                          = 19;
    const TP_PTR                            = 20;
    const TP_LDELIF                         = 21;
    const TP_SPACE                          = 22;
    const TP_LDELFOR                        = 23;
    const TP_SEMICOLON                      = 24;
    const TP_INCDEC                         = 25;
    const TP_TO                             = 26;
    const TP_STEP                           = 27;
    const TP_LDELFOREACH                    = 28;
    const TP_AS                             = 29;
    const TP_APTR                           = 30;
    const TP_SMARTYBLOCKCHILD               = 31;
    const TP_LDELSLASH                      = 32;
    const TP_INTEGER                        = 33;
    const TP_COMMA                          = 34;
    const TP_OPENP                          = 35;
    const TP_CLOSEP                         = 36;
    const TP_MATH                           = 37;
    const TP_UNIMATH                        = 38;
    const TP_ANDSYM                         = 39;
    const TP_ISIN                           = 40;
    const TP_ISDIVBY                        = 41;
    const TP_ISNOTDIVBY                     = 42;
    const TP_ISEVEN                         = 43;
    const TP_ISNOTEVEN                      = 44;
    const TP_ISEVENBY                       = 45;
    const TP_ISNOTEVENBY                    = 46;
    const TP_ISODD                          = 47;
    const TP_ISNOTODD                       = 48;
    const TP_ISODDBY                        = 49;
    const TP_ISNOTODDBY                     = 50;
    const TP_INSTANCEOF                     = 51;
    const TP_QMARK                          = 52;
    const TP_NOT                            = 53;
    const TP_TYPECAST                       = 54;
    const TP_HEX                            = 55;
    const TP_DOT                            = 56;
    const TP_SINGLEQUOTESTRING              = 57;
    const TP_DOUBLECOLON                    = 58;
    const TP_AT                             = 59;
    const TP_HATCH                          = 60;
    const TP_OPENB                          = 61;
    const TP_CLOSEB                         = 62;
    const TP_EQUALS                         = 63;
    const TP_NOTEQUALS                      = 64;
    const TP_GREATERTHAN                    = 65;
    const TP_LESSTHAN                       = 66;
    const TP_GREATEREQUAL                   = 67;
    const TP_LESSEQUAL                      = 68;
    const TP_IDENTITY                       = 69;
    const TP_NONEIDENTITY                   = 70;
    const TP_MOD                            = 71;
    const TP_LAND                           = 72;
    const TP_LOR                            = 73;
    const TP_LXOR                           = 74;
    const TP_QUOTE                          = 75;
    const TP_BACKTICK                       = 76;
    const TP_DOLLARID                       = 77;
    const YY_NO_ACTION = 584;
    const YY_ACCEPT_ACTION = 583;
    const YY_ERROR_ACTION = 582;

    const YY_SZ_ACTTAB = 2566;
static public $yy_action = array(
 /*     0 */   218,  272,  271,  275,  274,  278,  277,  276,  270,  262,
 /*    10 */   260,  264,  268,  196,  298,  285,   42,   22,  159,  265,
 /*    20 */    19,   29,  222,  374,  237,   29,  294,   29,  280,  149,
 /*    30 */   243,   19,  378,  225,  374,  244,   52,   47,   50,   45,
 /*    40 */    38,   37,  331,  332,   40,   39,  340,  337,   30,   25,
 /*    50 */   292,  299,  291,  290,  295,  190,  123,  342,  196,  279,
 /*    60 */   293,  135,  335,  322,  321,  308,  309,  310,  307,  306,
 /*    70 */   302,  303,  304,  305,  218,  242,  319,  175,  199,  133,
 /*    80 */   138,   19,  248,   72,  374,  124,   19,  288,  448,  374,
 /*    90 */    41,   14,  339,  311,  448,   29,  348,  329,  376,  320,
 /*   100 */    34,  583,   95,  273,  271,  275,  219,    3,  301,    3,
 /*   110 */    52,   47,   50,   45,   38,   37,  331,  332,   40,   39,
 /*   120 */   340,  337,   30,   25,    7,  231,   17,  108,  134,  167,
 /*   130 */   140,   35,  140,  143,  336,  192,  335,  322,  321,  308,
 /*   140 */   309,  310,  307,  306,  302,  303,  304,  305,  218,  334,
 /*   150 */   319,  193,  353,   10,  138,    3,  248,   55,    3,  119,
 /*   160 */   136,   36,   31,  371,  218,   19,  339,  311,  374,   29,
 /*   170 */   348,  329,   29,  320,  199,   27,  223,  258,  140,  372,
 /*   180 */   224,  140,  254,  220,   52,   47,   50,   45,   38,   37,
 /*   190 */   331,  332,   40,   39,  340,  337,   30,   25,  341,  179,
 /*   200 */    32,  159,  106,  323,   29,  194,  379,  342,  218,  288,
 /*   210 */   335,  322,  321,  308,  309,  310,  307,  306,  302,  303,
 /*   220 */   304,  305,  218,  366,  319,  199,  186,  218,  138,  190,
 /*   230 */   248,   72,  445,  124,  218,  266,  288,  364,  445,  123,
 /*   240 */   339,  311,  447,   29,  348,  329,   19,  320,  447,  374,
 /*   250 */    23,    3,  199,   16,  211,   29,  297,  170,   52,   47,
 /*   260 */    50,   45,   38,   37,  331,  332,   40,   39,  340,  337,
 /*   270 */    30,   25,  218,  172,  140,  183,  104,   46,   19,  189,
 /*   280 */   379,  374,   41,  288,  335,  322,  321,  308,  309,  310,
 /*   290 */   307,  306,  302,  303,  304,  305,  344,  188,  444,  199,
 /*   300 */   218,  235,  249,  216,   29,  191,  379,  342,   52,   47,
 /*   310 */    50,   45,   38,   37,  331,  332,   40,   39,  340,  337,
 /*   320 */    30,   25,  242,   19,  142,   43,  374,  130,  245,   28,
 /*   330 */    29,  159,  107,  346,  335,  322,  321,  308,  309,  310,
 /*   340 */   307,  306,  302,  303,  304,  305,  218,  347,  319,   27,
 /*   350 */    46,  257,  138,  198,  248,   62,  164,  119,  240,  218,
 /*   360 */   267,  252,  228,  126,  339,  311,  288,  205,  348,  329,
 /*   370 */   103,  320,    8,  261,  444,  357,  180,  376,  376,   29,
 /*   380 */    29,   29,   52,   47,   50,   45,   38,   37,  331,  332,
 /*   390 */    40,   39,  340,  337,   30,   25,  184,  349,  361,  365,
 /*   400 */    27,  284,  358,   29,   29,   29,  288,   29,  335,  322,
 /*   410 */   321,  308,  309,  310,  307,  306,  302,  303,  304,  305,
 /*   420 */   218,  319,  202,  221,  181,  138,  154,  248,   72,  171,
 /*   430 */   124,  313,    9,  162,  288,  289,  163,  339,  311,  288,
 /*   440 */   320,  348,  329,  288,  320,  376,  288,  281,  269,  370,
 /*   450 */   376,  214,    6,   29,   29,   29,   52,   47,   50,   45,
 /*   460 */    38,   37,  331,  332,   40,   39,  340,  337,   30,   25,
 /*   470 */   218,  178,  239,  283,  373,   19,  226,  238,  374,   29,
 /*   480 */    29,  288,  335,  322,  321,  308,  309,  310,  307,  306,
 /*   490 */   302,  303,  304,  305,  177,  205,  286,  202,  227,  377,
 /*   500 */     8,  166,   29,  376,  288,   29,   52,   47,   50,   45,
 /*   510 */    38,   37,  331,  332,   40,   39,  340,  337,   30,   25,
 /*   520 */   202,  218,  363,  375,  380,  315,  235,  296,   29,   29,
 /*   530 */    29,   29,  335,  322,  321,  308,  309,  310,  307,  306,
 /*   540 */   302,  303,  304,  305,  197,  369,  352,   19,  327,  218,
 /*   550 */   236,   29,   29,  165,  234,  156,  174,   52,   47,   50,
 /*   560 */    45,   38,   37,  331,  332,   40,   39,  340,  337,   30,
 /*   570 */    25,   26,  344,    5,   19,  314,  199,  212,   19,  199,
 /*   580 */   159,  241,  218,  335,  322,  321,  308,  309,  310,  307,
 /*   590 */   306,  302,  303,  304,  305,  218,  319,  300,  100,   46,
 /*   600 */   138,   19,  248,   76,  233,  124,    6,  218,  110,  351,
 /*   610 */   201,  338,  339,  311,  115,  168,  348,  329,  123,  320,
 /*   620 */   182,  338,  287,  234,  105,  288,  324,  338,  235,  240,
 /*   630 */   288,   52,   47,   50,   45,   38,   37,  331,  332,   40,
 /*   640 */    39,  340,  337,   30,   25,  218,  333,  144,  263,   33,
 /*   650 */    13,  342,  312,  156,   29,  355,   97,  335,  322,  321,
 /*   660 */   308,  309,  310,  307,  306,  302,  303,  304,  305,  338,
 /*   670 */   141,   32,  325,  121,  195,  131,  356,  229,  127,    2,
 /*   680 */   250,   52,   47,   50,   45,   38,   37,  331,  332,   40,
 /*   690 */    39,  340,  337,   30,   25,  318,  228,   11,  330,   94,
 /*   700 */   129,  282,  218,  253,  159,   29,  323,  335,  322,  321,
 /*   710 */   308,  309,  310,  307,  306,  302,  303,  304,  305,  218,
 /*   720 */   218,  319,   18,  101,  148,  122,  114,  248,   54,   44,
 /*   730 */   124,  202,   99,  158,  316,  367,  376,  339,  311,  338,
 /*   740 */    29,  348,  329,  376,  320,  338,  338,  354,  169,  368,
 /*   750 */   321,  321,  321,  321,  321,   52,   47,   50,   45,   38,
 /*   760 */    37,  331,  332,   40,   39,  340,  337,   30,   25,  218,
 /*   770 */    46,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*   780 */   113,  335,  322,  321,  308,  309,  310,  307,  306,  302,
 /*   790 */   303,  304,  305,  338,  321,  321,  321,  321,  321,  321,
 /*   800 */   321,  321,  321,  321,  256,   52,   47,   50,   45,   38,
 /*   810 */    37,  331,  332,   40,   39,  340,  337,   30,   25,  218,
 /*   820 */   321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*   830 */   321,  335,  322,  321,  308,  309,  310,  307,  306,  302,
 /*   840 */   303,  304,  305,  321,  321,  321,  321,  321,  321,  321,
 /*   850 */   321,  321,  321,  321,  321,   52,   47,   50,   45,   38,
 /*   860 */    37,  331,  332,   40,   39,  340,  337,   30,   25,  218,
 /*   870 */    12,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*   880 */   382,  335,  322,  321,  308,  309,  310,  307,  306,  302,
 /*   890 */   303,  304,  305,  321,  321,  321,  321,  321,  321,  321,
 /*   900 */   321,  321,  321,  321,  321,   52,   47,   50,   45,   38,
 /*   910 */    37,  331,  332,   40,   39,  340,  337,   30,   25,  321,
 /*   920 */   321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*   930 */   321,  335,  322,  321,  308,  309,  310,  307,  306,  302,
 /*   940 */   303,  304,  305,  218,  319,  321,  321,  321,  138,  321,
 /*   950 */   248,   61,  321,  124,  321,   98,  132,  321,  200,  321,
 /*   960 */   339,  311,  321,  321,  348,  329,  321,  320,  338,  338,
 /*   970 */   321,  321,  321,  321,  321,  321,  321,  321,  321,   52,
 /*   980 */    47,   50,   45,   38,   37,  331,  332,   40,   39,  340,
 /*   990 */   337,   30,   25,  218,  321,  321,  321,  321,  321,  321,
 /*  1000 */   321,  321,  321,  321,  321,  335,  322,  321,  308,  309,
 /*  1010 */   310,  307,  306,  302,  303,  304,  305,  321,  321,  321,
 /*  1020 */   321,  321,  321,  321,  321,  321,  321,  321,  321,   52,
 /*  1030 */    47,   50,   45,   38,   37,  331,  332,   40,   39,  340,
 /*  1040 */   337,   30,   25,  321,  321,  321,  321,  321,  321,  321,
 /*  1050 */   321,  321,  321,  321,  321,  335,  322,  321,  308,  309,
 /*  1060 */   310,  307,  306,  302,  303,  304,  305,   52,   47,   50,
 /*  1070 */    45,   38,   37,  331,  332,   40,   39,  340,  337,   30,
 /*  1080 */    25,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*  1090 */   321,  321,  321,  335,  322,  321,  308,  309,  310,  307,
 /*  1100 */   306,  302,  303,  304,  305,  321,  321,  321,  321,   42,
 /*  1110 */   321,  139,  207,  321,  319,  222,  321,  237,  138,  321,
 /*  1120 */   248,   78,  149,  124,  321,  378,  225,  232,  321,   15,
 /*  1130 */   339,  311,   49,  321,  348,  329,  321,  320,  321,  321,
 /*  1140 */   321,  321,  321,  321,  321,  321,  321,   51,   48,  317,
 /*  1150 */   247,  328,  321,  319,  103,    1,  255,  145,  321,  248,
 /*  1160 */   321,  321,  124,  321,   42,  321,  139,  209,  321,   96,
 /*  1170 */   222,  321,  237,  348,  329,  321,  320,  149,  345,  321,
 /*  1180 */   378,  225,  232,   24,   15,  321,  321,   49,  321,  222,
 /*  1190 */   321,  237,  321,  321,  321,  321,  149,  321,  321,  378,
 /*  1200 */   225,  321,   51,   48,  317,  247,  328,  321,  319,  103,
 /*  1210 */     1,  321,  146,  321,  248,  321,  321,  124,  321,   42,
 /*  1220 */   161,  130,  209,  193,   96,  222,  321,  237,  348,  329,
 /*  1230 */   288,  320,  149,   36,   31,  378,  225,  232,  321,   21,
 /*  1240 */   321,  321,   49,  350,   20,  343,  199,  319,  218,  321,
 /*  1250 */   321,  155,  321,  248,  321,  321,  124,   51,   48,  317,
 /*  1260 */   247,  328,  321,  450,  103,    1,  321,  348,  329,  450,
 /*  1270 */   320,  321,  321,  321,   42,  321,  125,  209,  321,   96,
 /*  1280 */   222,  321,  237,  321,  321,  321,  321,  149,  345,  321,
 /*  1290 */   378,  225,  232,   24,    4,  321,  321,   49,   46,  222,
 /*  1300 */   321,  237,  321,  321,  321,  321,  149,  321,  321,  378,
 /*  1310 */   225,  321,   51,   48,  317,  247,  328,  321,  319,  103,
 /*  1320 */     1,  321,  151,  321,  248,  321,  321,  124,  321,   42,
 /*  1330 */   176,  139,  204,  193,   96,  222,  321,  237,  348,  329,
 /*  1340 */   288,  320,  149,   36,   31,  378,  225,  215,  321,   15,
 /*  1350 */   321,  321,   49,  362,   20,  343,  199,  319,  218,  321,
 /*  1360 */   321,  150,  321,  248,  321,  321,  124,   51,   48,  317,
 /*  1370 */   247,  328,  321,  259,  103,    1,  321,  348,  329,   29,
 /*  1380 */   320,  321,  321,  321,   42,  173,  128,   92,  193,   96,
 /*  1390 */   222,  321,  237,  321,  218,  288,  321,  149,   36,   31,
 /*  1400 */   378,  225,  232,  321,   15,  321,  321,   49,   46,  381,
 /*  1410 */   321,  199,  319,  230,  321,   29,  152,  321,  248,  321,
 /*  1420 */   321,  124,   51,   48,  317,  247,  328,  321,    3,  103,
 /*  1430 */     1,  321,  348,  329,  321,  320,  321,  321,  321,   42,
 /*  1440 */   185,  139,  208,  102,   96,  222,  321,  237,  321,  321,
 /*  1450 */   288,  140,  149,   36,   31,  378,  225,  232,  321,   15,
 /*  1460 */   321,  321,   49,  321,  321,  321,  199,  319,  321,  321,
 /*  1470 */   321,  147,  321,  248,  321,  321,  124,   51,   48,  317,
 /*  1480 */   247,  328,  321,  321,  103,    1,  321,  348,  329,  321,
 /*  1490 */   320,  321,  321,  321,   42,  187,  139,  203,  193,   96,
 /*  1500 */   222,  321,  237,  321,  321,  288,  321,  149,   36,   31,
 /*  1510 */   378,  225,  232,  321,   15,  321,  160,   49,  321,  193,
 /*  1520 */   321,  199,  321,  321,  321,  321,  288,  321,  321,   36,
 /*  1530 */    31,  321,   51,   48,  317,  247,  328,  321,  321,  103,
 /*  1540 */     1,  321,  199,  321,  321,  321,  321,  321,  321,   42,
 /*  1550 */   321,  139,  206,  218,   96,  222,  321,  237,  321,  321,
 /*  1560 */   321,  321,  149,  321,  321,  378,  225,  232,  450,   15,
 /*  1570 */   321,  321,   49,  321,  450,  321,  321,  321,  321,  321,
 /*  1580 */   321,  246,  321,  321,  321,  321,  321,   51,   48,  317,
 /*  1590 */   247,  328,  321,  321,  103,    1,  321,  321,  321,  321,
 /*  1600 */   321,  321,  321,   46,   42,  321,  137,  209,  321,   96,
 /*  1610 */   222,  321,  237,  321,  321,  321,  321,  149,  321,  321,
 /*  1620 */   378,  225,  232,  321,   15,  321,  321,   49,  321,  321,
 /*  1630 */   321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*  1640 */   321,  321,   51,   48,  317,  247,  328,  321,  321,  103,
 /*  1650 */     1,  321,  321,  321,  321,  321,  321,  321,  321,   42,
 /*  1660 */   321,  130,  210,  321,   96,  222,  321,  237,  321,  321,
 /*  1670 */   321,  321,  149,  321,  321,  378,  225,  232,  321,   21,
 /*  1680 */   321,  321,   49,  321,  321,  321,  321,  321,  321,  321,
 /*  1690 */   321,  321,  321,  321,  321,  321,  321,   51,   48,  317,
 /*  1700 */   247,  328,  321,  321,  103,  321,  321,  321,  321,  321,
 /*  1710 */   321,  321,  321,  321,   42,  321,  130,  209,  321,   96,
 /*  1720 */   222,  321,  237,  321,  321,  321,  321,  149,  321,  321,
 /*  1730 */   378,  225,  232,  321,   21,  321,  321,   49,  321,  321,
 /*  1740 */   321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*  1750 */   321,  321,   51,   48,  317,  247,  328,  321,  321,  103,
 /*  1760 */   321,  321,  321,  321,  321,  321,  321,  321,  321,  493,
 /*  1770 */   321,  321,  321,  321,   96,  493,  321,  493,  321,  493,
 /*  1780 */   493,  321,  493,  321,  321,  321,  321,  493,    3,  493,
 /*  1790 */   321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*  1800 */   321,  321,  321,  319,  493,  321,  321,  117,  321,  248,
 /*  1810 */    82,  140,  124,  321,  321,  493,  321,  321,  321,  339,
 /*  1820 */   311,  321,  321,  348,  329,  321,  320,  321,  321,  493,
 /*  1830 */   321,  321,  321,  321,  321,  321,  319,  217,  360,  321,
 /*  1840 */   117,  321,  248,   82,  321,  124,  321,  321,  321,  321,
 /*  1850 */   321,  321,  339,  311,  321,  321,  348,  329,  319,  320,
 /*  1860 */   321,  321,  138,  321,  248,   90,  321,  124,  321,  321,
 /*  1870 */   321,  359,  321,  321,  339,  311,  321,  321,  348,  329,
 /*  1880 */   321,  320,  321,  321,  321,  321,  319,  321,  321,  321,
 /*  1890 */   138,  321,  248,   69,  321,  124,  321,  321,  321,  321,
 /*  1900 */   321,  321,  339,  311,  321,  321,  348,  329,  321,  320,
 /*  1910 */   321,  321,  319,  321,  321,  321,  138,  321,  248,   67,
 /*  1920 */   321,  124,  321,  321,  321,  321,  321,  321,  339,  311,
 /*  1930 */   321,  321,  348,  329,  321,  320,  319,  321,  321,  321,
 /*  1940 */   138,  321,  248,   58,  321,  124,  321,  321,  321,  321,
 /*  1950 */   321,  321,  339,  311,  319,  321,  348,  329,  138,  320,
 /*  1960 */   248,   62,  321,  124,  321,  321,  321,  321,  321,  321,
 /*  1970 */   339,  311,  321,  321,  348,  329,  319,  320,  321,  321,
 /*  1980 */   138,  321,  248,   56,  321,  124,  321,  321,  321,  321,
 /*  1990 */   321,  321,  339,  311,  321,  321,  348,  329,  321,  320,
 /*  2000 */   321,  319,  321,  321,  321,  112,  321,  248,   71,  321,
 /*  2010 */   124,  321,  321,  321,  321,  321,  321,  339,  311,  319,
 /*  2020 */   321,  348,  329,  111,  320,  248,   81,  321,  124,  321,
 /*  2030 */   321,  321,  321,  321,  321,  339,  311,  319,  321,  348,
 /*  2040 */   329,  138,  320,  248,   74,  321,  124,  321,  321,  321,
 /*  2050 */   321,  321,  321,  339,  311,  321,  321,  348,  329,  319,
 /*  2060 */   320,  321,  321,  138,  321,  248,   91,  321,  124,  321,
 /*  2070 */   321,  321,  321,  321,  321,  339,  311,  321,  321,  348,
 /*  2080 */   329,  321,  320,  321,  319,  321,  321,  321,  138,  321,
 /*  2090 */   248,   64,  321,  124,  321,  321,  321,  321,  321,  321,
 /*  2100 */   339,  311,  319,  321,  348,  329,  138,  320,  248,   63,
 /*  2110 */   321,  124,  321,  321,  321,  321,  321,  321,  339,  311,
 /*  2120 */   319,  321,  348,  329,  138,  320,  248,   83,  321,  124,
 /*  2130 */   321,  321,  321,  321,  321,  321,  339,  311,  321,  321,
 /*  2140 */   348,  329,  319,  320,  321,  321,  138,  321,  248,   79,
 /*  2150 */   321,  124,  321,  321,  321,  321,  321,  321,  339,  311,
 /*  2160 */   321,  321,  348,  329,  321,  320,  321,  319,  321,  321,
 /*  2170 */   321,  138,  321,  248,   75,  321,  124,  321,  321,  321,
 /*  2180 */   321,  321,  321,  339,  311,  319,  321,  348,  329,  138,
 /*  2190 */   320,  248,   70,  321,  124,  321,  321,  321,  321,  321,
 /*  2200 */   321,  339,  311,  319,  321,  348,  329,  109,  320,  248,
 /*  2210 */    68,  321,  124,  321,  321,  321,  321,  321,  321,  339,
 /*  2220 */   311,  321,  321,  348,  329,  319,  320,  321,  321,  138,
 /*  2230 */   321,  248,   77,  321,  124,  321,  321,  321,  321,  321,
 /*  2240 */   321,  339,  311,  321,  321,  348,  329,  321,  320,  321,
 /*  2250 */   319,  321,  321,  321,  138,  321,  248,   73,  321,  124,
 /*  2260 */   321,  321,  321,  321,  321,  321,  339,  311,  319,  321,
 /*  2270 */   348,  329,  138,  320,  213,   65,  321,  124,  321,  321,
 /*  2280 */   321,  321,  321,  321,  339,  311,  319,  321,  348,  329,
 /*  2290 */   138,  320,  248,   86,  321,  124,  321,  321,  321,  321,
 /*  2300 */   321,  321,  339,  311,  321,  321,  348,  329,  319,  320,
 /*  2310 */   321,  321,  138,  321,  248,   88,  321,  124,  321,  321,
 /*  2320 */   321,  321,  321,  321,  339,  311,  321,  321,  348,  329,
 /*  2330 */   321,  320,  321,  319,  321,  321,  321,   93,  321,  120,
 /*  2340 */    59,  321,  116,  321,  321,  321,  321,  321,  321,  339,
 /*  2350 */   311,  319,  321,  348,  329,  138,  320,  248,   57,  321,
 /*  2360 */   124,  321,  321,  321,  321,  321,  321,  339,  311,  319,
 /*  2370 */   321,  348,  329,  138,  320,  248,   60,  321,  124,  321,
 /*  2380 */   321,  321,  321,  321,  321,  339,  311,  321,  321,  348,
 /*  2390 */   329,  319,  320,  321,  321,  138,  321,  248,   89,  321,
 /*  2400 */   124,  321,  321,  321,  321,  321,  321,  339,  311,  321,
 /*  2410 */   321,  348,  329,  321,  320,  321,  319,  321,  321,  321,
 /*  2420 */   138,  321,  248,   85,  321,  124,  321,  321,  321,  321,
 /*  2430 */   321,  321,  339,  311,  319,  321,  348,  329,  138,  320,
 /*  2440 */   248,   80,  321,  124,  321,  321,  321,  321,  321,  321,
 /*  2450 */   339,  311,  319,  321,  348,  329,  138,  320,  248,   84,
 /*  2460 */   321,  124,  321,  321,  321,  321,  321,  321,  339,  311,
 /*  2470 */   321,  321,  348,  329,  319,  320,  321,  321,  138,  321,
 /*  2480 */   248,   66,  321,  124,  321,  321,  321,  321,  321,  321,
 /*  2490 */   339,  311,  321,  321,  348,  329,  321,  320,  321,  319,
 /*  2500 */   321,  321,  321,  138,  321,  248,   87,  321,  124,  321,
 /*  2510 */   321,  321,  321,  321,  321,  339,  311,  319,  321,  348,
 /*  2520 */   329,   93,  320,  118,   53,  321,  116,  321,  321,  321,
 /*  2530 */   321,  321,  321,  339,  311,  319,  321,  348,  329,  153,
 /*  2540 */   320,  248,  319,  321,  124,  321,  157,  321,  248,  321,
 /*  2550 */   321,  124,  326,  321,  321,  348,  329,  321,  320,  251,
 /*  2560 */   321,  321,  348,  329,  321,  320,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   81,   82,   83,    3,    4,    5,    6,    7,    8,
 /*    10 */     9,   10,   11,   12,   22,   16,   15,   19,   20,   16,
 /*    20 */    15,   22,   21,   18,   23,   22,   83,   22,   85,   28,
 /*    30 */    94,   15,   31,   32,   18,   30,   37,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    50 */     4,    5,    6,    7,    8,   90,   58,   25,   12,   13,
 /*    60 */    14,   17,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,    1,   59,   82,   87,  113,   35,
 /*    80 */    86,   15,   88,   89,   18,   91,   15,   97,   16,   18,
 /*    90 */    19,   19,   98,   99,   22,   22,  102,  103,  108,  105,
 /*   100 */    27,   79,   80,   81,   82,   83,  112,   35,   76,   35,
 /*   110 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   120 */    47,   48,   49,   50,   34,   59,   15,   84,   17,   18,
 /*   130 */    58,   15,   58,   17,   18,  114,   63,   64,   65,   66,
 /*   140 */    67,   68,   69,   70,   71,   72,   73,   74,    1,   33,
 /*   150 */    82,   90,   62,   30,   86,   35,   88,   89,   35,   91,
 /*   160 */    92,  100,  101,   16,    1,   15,   98,   99,   18,   22,
 /*   170 */   102,  103,   22,  105,  113,   34,   56,   36,   58,   16,
 /*   180 */    30,   58,   62,   20,   37,   38,   39,   40,   41,   42,
 /*   190 */    43,   44,   45,   46,   47,   48,   49,   50,   16,   87,
 /*   200 */    19,   20,   90,  107,   22,  109,  110,   25,    1,   97,
 /*   210 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   220 */    73,   74,    1,   16,   82,  113,   87,    1,   86,   90,
 /*   230 */    88,   89,   16,   91,    1,   13,   97,   16,   22,   58,
 /*   240 */    98,   99,   16,   22,  102,  103,   15,  105,   22,   18,
 /*   250 */    19,   35,  113,   94,  112,   22,   25,  106,   37,   38,
 /*   260 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   270 */    49,   50,    1,   87,   58,  106,   90,   51,   15,  109,
 /*   280 */   110,   18,   19,   97,   63,   64,   65,   66,   67,   68,
 /*   290 */    69,   70,   71,   72,   73,   74,   82,  114,   16,  113,
 /*   300 */     1,   91,   92,   93,   22,  109,  110,   25,   37,   38,
 /*   310 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   320 */    49,   50,   59,   15,   17,   19,   18,   17,   18,   30,
 /*   330 */    22,   20,  118,  119,   63,   64,   65,   66,   67,   68,
 /*   340 */    69,   70,   71,   72,   73,   74,    1,   76,   82,   34,
 /*   350 */    51,   36,   86,   24,   88,   89,   87,   91,   92,    1,
 /*   360 */    36,   16,   56,   34,   98,   99,   97,   56,  102,  103,
 /*   370 */    60,  105,   61,   16,   16,   16,  106,  108,  108,   22,
 /*   380 */    22,   22,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   390 */    45,   46,   47,   48,   49,   50,   87,   16,   16,   16,
 /*   400 */    34,   16,   36,   22,   22,   22,   97,   22,   63,   64,
 /*   410 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   420 */     1,   82,  113,   88,   87,   86,   91,   88,   89,   87,
 /*   430 */    91,   18,   15,   87,   97,   16,   87,   98,   99,   97,
 /*   440 */   105,  102,  103,   97,  105,  108,   97,   16,   16,   16,
 /*   450 */   108,  112,   35,   22,   22,   22,   37,   38,   39,   40,
 /*   460 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   470 */     1,   87,   59,   16,   16,   15,   17,   18,   18,   22,
 /*   480 */    22,   97,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   490 */    71,   72,   73,   74,   87,   56,   16,  113,   29,   16,
 /*   500 */    61,  106,   22,  108,   97,   22,   37,   38,   39,   40,
 /*   510 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   520 */   113,    1,   16,   16,   16,   16,   91,   92,   22,   22,
 /*   530 */    22,   22,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   540 */    71,   72,   73,   74,   24,   16,   16,   15,  104,    1,
 /*   550 */    18,   22,   22,   90,    2,  111,   90,   37,   38,   39,
 /*   560 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   570 */    50,   19,   82,   35,   15,   18,  113,   18,   15,  113,
 /*   580 */    20,   18,    1,   63,   64,   65,   66,   67,   68,   69,
 /*   590 */    70,   71,   72,   73,   74,    1,   82,   16,   95,   51,
 /*   600 */    86,   15,   88,   89,   18,   91,   35,    1,   95,  119,
 /*   610 */    16,  108,   98,   99,   95,   87,  102,  103,   58,  105,
 /*   620 */    87,  108,   16,    2,   22,   97,   18,  108,   91,   92,
 /*   630 */    97,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   640 */    46,   47,   48,   49,   50,    1,  104,   17,   16,   26,
 /*   650 */    52,   25,   33,  111,   22,   60,   95,   63,   64,   65,
 /*   660 */    66,   67,   68,   69,   70,   71,   72,   73,   74,  108,
 /*   670 */    17,   19,   18,   18,   18,   17,   60,   18,   17,   22,
 /*   680 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*   690 */    46,   47,   48,   49,   50,   33,   56,    2,   18,   18,
 /*   700 */    18,   97,    1,   62,   20,   22,  107,   63,   64,   65,
 /*   710 */    66,   67,   68,   69,   70,   71,   72,   73,   74,    1,
 /*   720 */     1,   82,   22,  106,   96,   86,   95,   88,   89,    2,
 /*   730 */    91,  113,   95,   95,  110,   16,  108,   98,   99,  108,
 /*   740 */    22,  102,  103,  108,  105,  108,  108,  111,  106,  115,
 /*   750 */   120,  120,  120,  120,  120,   37,   38,   39,   40,   41,
 /*   760 */    42,   43,   44,   45,   46,   47,   48,   49,   50,    1,
 /*   770 */    51,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   780 */    95,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   790 */    72,   73,   74,  108,  120,  120,  120,  120,  120,  120,
 /*   800 */   120,  120,  120,  120,   36,   37,   38,   39,   40,   41,
 /*   810 */    42,   43,   44,   45,   46,   47,   48,   49,   50,    1,
 /*   820 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   830 */   120,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   840 */    72,   73,   74,  120,  120,  120,  120,  120,  120,  120,
 /*   850 */   120,  120,  120,  120,  120,   37,   38,   39,   40,   41,
 /*   860 */    42,   43,   44,   45,   46,   47,   48,   49,   50,    1,
 /*   870 */     2,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   880 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   890 */    72,   73,   74,  120,  120,  120,  120,  120,  120,  120,
 /*   900 */   120,  120,  120,  120,  120,   37,   38,   39,   40,   41,
 /*   910 */    42,   43,   44,   45,   46,   47,   48,   49,   50,  120,
 /*   920 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   930 */   120,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   940 */    72,   73,   74,    1,   82,  120,  120,  120,   86,  120,
 /*   950 */    88,   89,  120,   91,  120,   95,   95,  120,   16,  120,
 /*   960 */    98,   99,  120,  120,  102,  103,  120,  105,  108,  108,
 /*   970 */   120,  120,  120,  120,  120,  120,  120,  120,  120,   37,
 /*   980 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   990 */    48,   49,   50,    1,  120,  120,  120,  120,  120,  120,
 /*  1000 */   120,  120,  120,  120,  120,   63,   64,   65,   66,   67,
 /*  1010 */    68,   69,   70,   71,   72,   73,   74,  120,  120,  120,
 /*  1020 */   120,  120,  120,  120,  120,  120,  120,  120,  120,   37,
 /*  1030 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*  1040 */    48,   49,   50,  120,  120,  120,  120,  120,  120,  120,
 /*  1050 */   120,  120,  120,  120,  120,   63,   64,   65,   66,   67,
 /*  1060 */    68,   69,   70,   71,   72,   73,   74,   37,   38,   39,
 /*  1070 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*  1080 */    50,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1090 */   120,  120,  120,   63,   64,   65,   66,   67,   68,   69,
 /*  1100 */    70,   71,   72,   73,   74,  120,  120,  120,  120,   15,
 /*  1110 */   120,   17,   18,  120,   82,   21,  120,   23,   86,  120,
 /*  1120 */    88,   89,   28,   91,  120,   31,   32,   33,  120,   35,
 /*  1130 */    98,   99,   38,  120,  102,  103,  120,  105,  120,  120,
 /*  1140 */   120,  120,  120,  120,  120,  120,  120,   53,   54,   55,
 /*  1150 */    56,   57,  120,   82,   60,   61,   62,   86,  120,   88,
 /*  1160 */   120,  120,   91,  120,   15,  120,   17,   18,  120,   75,
 /*  1170 */    21,  120,   23,  102,  103,  120,  105,   28,   10,  120,
 /*  1180 */    31,   32,   33,   15,   35,  120,  120,   38,  120,   21,
 /*  1190 */   120,   23,  120,  120,  120,  120,   28,  120,  120,   31,
 /*  1200 */    32,  120,   53,   54,   55,   56,   57,  120,   82,   60,
 /*  1210 */    61,  120,   86,  120,   88,  120,  120,   91,  120,   15,
 /*  1220 */    87,   17,   18,   90,   75,   21,  120,   23,  102,  103,
 /*  1230 */    97,  105,   28,  100,  101,   31,   32,   33,  120,   35,
 /*  1240 */   120,  120,   38,   75,   76,   77,  113,   82,    1,  120,
 /*  1250 */   120,   86,  120,   88,  120,  120,   91,   53,   54,   55,
 /*  1260 */    56,   57,  120,   16,   60,   61,  120,  102,  103,   22,
 /*  1270 */   105,  120,  120,  120,   15,  120,   17,   18,  120,   75,
 /*  1280 */    21,  120,   23,  120,  120,  120,  120,   28,   10,  120,
 /*  1290 */    31,   32,   33,   15,   35,  120,  120,   38,   51,   21,
 /*  1300 */   120,   23,  120,  120,  120,  120,   28,  120,  120,   31,
 /*  1310 */    32,  120,   53,   54,   55,   56,   57,  120,   82,   60,
 /*  1320 */    61,  120,   86,  120,   88,  120,  120,   91,  120,   15,
 /*  1330 */    87,   17,   18,   90,   75,   21,  120,   23,  102,  103,
 /*  1340 */    97,  105,   28,  100,  101,   31,   32,   33,  120,   35,
 /*  1350 */   120,  120,   38,   75,   76,   77,  113,   82,    1,  120,
 /*  1360 */   120,   86,  120,   88,  120,  120,   91,   53,   54,   55,
 /*  1370 */    56,   57,  120,   16,   60,   61,  120,  102,  103,   22,
 /*  1380 */   105,  120,  120,  120,   15,   87,   17,   18,   90,   75,
 /*  1390 */    21,  120,   23,  120,    1,   97,  120,   28,  100,  101,
 /*  1400 */    31,   32,   33,  120,   35,  120,  120,   38,   51,   16,
 /*  1410 */   120,  113,   82,   20,  120,   22,   86,  120,   88,  120,
 /*  1420 */   120,   91,   53,   54,   55,   56,   57,  120,   35,   60,
 /*  1430 */    61,  120,  102,  103,  120,  105,  120,  120,  120,   15,
 /*  1440 */    87,   17,   18,   90,   75,   21,  120,   23,  120,  120,
 /*  1450 */    97,   58,   28,  100,  101,   31,   32,   33,  120,   35,
 /*  1460 */   120,  120,   38,  120,  120,  120,  113,   82,  120,  120,
 /*  1470 */   120,   86,  120,   88,  120,  120,   91,   53,   54,   55,
 /*  1480 */    56,   57,  120,  120,   60,   61,  120,  102,  103,  120,
 /*  1490 */   105,  120,  120,  120,   15,   87,   17,   18,   90,   75,
 /*  1500 */    21,  120,   23,  120,  120,   97,  120,   28,  100,  101,
 /*  1510 */    31,   32,   33,  120,   35,  120,   87,   38,  120,   90,
 /*  1520 */   120,  113,  120,  120,  120,  120,   97,  120,  120,  100,
 /*  1530 */   101,  120,   53,   54,   55,   56,   57,  120,  120,   60,
 /*  1540 */    61,  120,  113,  120,  120,  120,  120,  120,  120,   15,
 /*  1550 */   120,   17,   18,    1,   75,   21,  120,   23,  120,  120,
 /*  1560 */   120,  120,   28,  120,  120,   31,   32,   33,   16,   35,
 /*  1570 */   120,  120,   38,  120,   22,  120,  120,  120,  120,  120,
 /*  1580 */   120,   29,  120,  120,  120,  120,  120,   53,   54,   55,
 /*  1590 */    56,   57,  120,  120,   60,   61,  120,  120,  120,  120,
 /*  1600 */   120,  120,  120,   51,   15,  120,   17,   18,  120,   75,
 /*  1610 */    21,  120,   23,  120,  120,  120,  120,   28,  120,  120,
 /*  1620 */    31,   32,   33,  120,   35,  120,  120,   38,  120,  120,
 /*  1630 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1640 */   120,  120,   53,   54,   55,   56,   57,  120,  120,   60,
 /*  1650 */    61,  120,  120,  120,  120,  120,  120,  120,  120,   15,
 /*  1660 */   120,   17,   18,  120,   75,   21,  120,   23,  120,  120,
 /*  1670 */   120,  120,   28,  120,  120,   31,   32,   33,  120,   35,
 /*  1680 */   120,  120,   38,  120,  120,  120,  120,  120,  120,  120,
 /*  1690 */   120,  120,  120,  120,  120,  120,  120,   53,   54,   55,
 /*  1700 */    56,   57,  120,  120,   60,  120,  120,  120,  120,  120,
 /*  1710 */   120,  120,  120,  120,   15,  120,   17,   18,  120,   75,
 /*  1720 */    21,  120,   23,  120,  120,  120,  120,   28,  120,  120,
 /*  1730 */    31,   32,   33,  120,   35,  120,  120,   38,  120,  120,
 /*  1740 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1750 */   120,  120,   53,   54,   55,   56,   57,  120,  120,   60,
 /*  1760 */   120,  120,  120,  120,  120,  120,  120,  120,  120,   16,
 /*  1770 */   120,  120,  120,  120,   75,   22,  120,   24,  120,   26,
 /*  1780 */    27,  120,   29,  120,  120,  120,  120,   34,   35,   36,
 /*  1790 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1800 */   120,  120,  120,   82,   51,  120,  120,   86,  120,   88,
 /*  1810 */    89,   58,   91,  120,  120,   62,  120,  120,  120,   98,
 /*  1820 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   76,
 /*  1830 */   120,  120,  120,  120,  120,  120,   82,  116,  117,  120,
 /*  1840 */    86,  120,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  1850 */   120,  120,   98,   99,  120,  120,  102,  103,   82,  105,
 /*  1860 */   120,  120,   86,  120,   88,   89,  120,   91,  120,  120,
 /*  1870 */   120,  117,  120,  120,   98,   99,  120,  120,  102,  103,
 /*  1880 */   120,  105,  120,  120,  120,  120,   82,  120,  120,  120,
 /*  1890 */    86,  120,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  1900 */   120,  120,   98,   99,  120,  120,  102,  103,  120,  105,
 /*  1910 */   120,  120,   82,  120,  120,  120,   86,  120,   88,   89,
 /*  1920 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  1930 */   120,  120,  102,  103,  120,  105,   82,  120,  120,  120,
 /*  1940 */    86,  120,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  1950 */   120,  120,   98,   99,   82,  120,  102,  103,   86,  105,
 /*  1960 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  1970 */    98,   99,  120,  120,  102,  103,   82,  105,  120,  120,
 /*  1980 */    86,  120,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  1990 */   120,  120,   98,   99,  120,  120,  102,  103,  120,  105,
 /*  2000 */   120,   82,  120,  120,  120,   86,  120,   88,   89,  120,
 /*  2010 */    91,  120,  120,  120,  120,  120,  120,   98,   99,   82,
 /*  2020 */   120,  102,  103,   86,  105,   88,   89,  120,   91,  120,
 /*  2030 */   120,  120,  120,  120,  120,   98,   99,   82,  120,  102,
 /*  2040 */   103,   86,  105,   88,   89,  120,   91,  120,  120,  120,
 /*  2050 */   120,  120,  120,   98,   99,  120,  120,  102,  103,   82,
 /*  2060 */   105,  120,  120,   86,  120,   88,   89,  120,   91,  120,
 /*  2070 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2080 */   103,  120,  105,  120,   82,  120,  120,  120,   86,  120,
 /*  2090 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  2100 */    98,   99,   82,  120,  102,  103,   86,  105,   88,   89,
 /*  2110 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  2120 */    82,  120,  102,  103,   86,  105,   88,   89,  120,   91,
 /*  2130 */   120,  120,  120,  120,  120,  120,   98,   99,  120,  120,
 /*  2140 */   102,  103,   82,  105,  120,  120,   86,  120,   88,   89,
 /*  2150 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  2160 */   120,  120,  102,  103,  120,  105,  120,   82,  120,  120,
 /*  2170 */   120,   86,  120,   88,   89,  120,   91,  120,  120,  120,
 /*  2180 */   120,  120,  120,   98,   99,   82,  120,  102,  103,   86,
 /*  2190 */   105,   88,   89,  120,   91,  120,  120,  120,  120,  120,
 /*  2200 */   120,   98,   99,   82,  120,  102,  103,   86,  105,   88,
 /*  2210 */    89,  120,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2220 */    99,  120,  120,  102,  103,   82,  105,  120,  120,   86,
 /*  2230 */   120,   88,   89,  120,   91,  120,  120,  120,  120,  120,
 /*  2240 */   120,   98,   99,  120,  120,  102,  103,  120,  105,  120,
 /*  2250 */    82,  120,  120,  120,   86,  120,   88,   89,  120,   91,
 /*  2260 */   120,  120,  120,  120,  120,  120,   98,   99,   82,  120,
 /*  2270 */   102,  103,   86,  105,   88,   89,  120,   91,  120,  120,
 /*  2280 */   120,  120,  120,  120,   98,   99,   82,  120,  102,  103,
 /*  2290 */    86,  105,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  2300 */   120,  120,   98,   99,  120,  120,  102,  103,   82,  105,
 /*  2310 */   120,  120,   86,  120,   88,   89,  120,   91,  120,  120,
 /*  2320 */   120,  120,  120,  120,   98,   99,  120,  120,  102,  103,
 /*  2330 */   120,  105,  120,   82,  120,  120,  120,   86,  120,   88,
 /*  2340 */    89,  120,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2350 */    99,   82,  120,  102,  103,   86,  105,   88,   89,  120,
 /*  2360 */    91,  120,  120,  120,  120,  120,  120,   98,   99,   82,
 /*  2370 */   120,  102,  103,   86,  105,   88,   89,  120,   91,  120,
 /*  2380 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2390 */   103,   82,  105,  120,  120,   86,  120,   88,   89,  120,
 /*  2400 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2410 */   120,  102,  103,  120,  105,  120,   82,  120,  120,  120,
 /*  2420 */    86,  120,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  2430 */   120,  120,   98,   99,   82,  120,  102,  103,   86,  105,
 /*  2440 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  2450 */    98,   99,   82,  120,  102,  103,   86,  105,   88,   89,
 /*  2460 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  2470 */   120,  120,  102,  103,   82,  105,  120,  120,   86,  120,
 /*  2480 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  2490 */    98,   99,  120,  120,  102,  103,  120,  105,  120,   82,
 /*  2500 */   120,  120,  120,   86,  120,   88,   89,  120,   91,  120,
 /*  2510 */   120,  120,  120,  120,  120,   98,   99,   82,  120,  102,
 /*  2520 */   103,   86,  105,   88,   89,  120,   91,  120,  120,  120,
 /*  2530 */   120,  120,  120,   98,   99,   82,  120,  102,  103,   86,
 /*  2540 */   105,   88,   82,  120,   91,  120,   86,  120,   88,  120,
 /*  2550 */   120,   91,   99,  120,  120,  102,  103,  120,  105,   99,
 /*  2560 */   120,  120,  102,  103,  120,  105,
);
    const YY_SHIFT_USE_DFLT = -9;
    const YY_SHIFT_MAX = 250;
    static public $yy_shift_ofst = array(
 /*     0 */     1, 1424, 1259, 1149, 1259, 1149, 1149, 1424, 1094, 1149,
 /*    10 */  1149, 1479, 1149, 1589, 1534, 1149, 1149, 1149, 1314, 1149,
 /*    20 */  1149, 1149, 1149, 1149, 1369, 1149, 1149, 1149, 1149, 1314,
 /*    30 */  1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
 /*    40 */  1149, 1149, 1369, 1149, 1204, 1204, 1644, 1699, 1699, 1699,
 /*    50 */  1699, 1699, 1699,  147,  221,   -1,   73,  718,  718,  718,
 /*    60 */   768,  818,  644,  594,  345,  271,  419,  942,  469,  520,
 /*    70 */   868,  992,  992,  992,  992,  992,  992,  992,  992,  992,
 /*    80 */   992,  992,  992,  992,  992,  992,  992,  992,  992,  992,
 /*    90 */  1030, 1030, 1393, 1357,  233,    1, 1278,  150,    5,  308,
 /*   100 */   308,  311,  358,  310,  233,   44,  233, 1168,   46, 1552,
 /*   110 */   263, 1247,  226,  231,   71,   16,   -2,  299,  182,  181,
 /*   120 */   282,  163,  719,  459,  560,  532,   44,  460,  559,  581,
 /*   130 */   460,  460,  460,   44,  563,  460,  632,  586,  548,  532,
 /*   140 */   459,  460,  460,  460,  460,  701,  701,  701,  683,  700,
 /*   150 */   701,  701,  701,  701,  684,  701,  684,   -9,   66,  111,
 /*   160 */     3,  357,  359,  382,  381,  606,  439,  417,  509,  439,
 /*   170 */   439,  530,  508,  458,  207,  431,  480,  507,  506,  483,
 /*   180 */   439,  457,  432,  439,  529,  433,  385,  383,  727,  684,
 /*   190 */   701,  684,  727,  701,  684,  538,  222,   -8,   -8,   -9,
 /*   200 */    -9,   -9,   -9, 1753,   72,  116,  216,  120,  123,   74,
 /*   210 */    74,  141,  552,   32,  315,  306,  329,   90,  413,  366,
 /*   220 */   682,  616,  657,  659,  658,  655,  656,  661,  662,  641,
 /*   230 */   681,  680,  640,  695,  654,  652,  621,  602,  571,  557,
 /*   240 */   324,  538,  608,  307,  630,  595,  653,  619,  626,  623,
 /*   250 */   598,
);
    const YY_REDUCE_USE_DFLT = -81;
    const YY_REDUCE_MAX = 202;
    static public $yy_reduce_ofst = array(
 /*     0 */    22, 1721,   68,  339,  266,   -6,  142, 1754,  862, 2020,
 /*    10 */   514, 1977, 1776, 2103, 1919, 1872, 1804, 1830, 2121, 2392,
 /*    20 */  2186, 2287, 2269, 2168, 2435, 2143,  639, 1955, 2085, 1937,
 /*    30 */  1032, 2060, 2038, 1894, 1854, 2002, 2352, 2417, 2370, 2334,
 /*    40 */  2204, 2226, 2251, 2309, 2460, 2453, 1071, 1126, 1275, 1385,
 /*    50 */  1330, 1236, 1165, 1353, 1408, 1243, 1429, 1298, 1133, 1353,
 /*    60 */    61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
 /*    70 */    61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
 /*    80 */    61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
 /*    90 */    61,   61,  186,  139,  112,  -80,  214,  -10,  342,  337,
 /*   100 */   269,   96,  309,  335,  384,  210,  407,  490,  -57,  -35,
 /*   110 */   270,  -35,  -35,  628,  270,  270,  170,  -35,  528,  170,
 /*   120 */   528,  466,  -35,  444,  170,  513,  435,  561,  519,  463,
 /*   130 */   519,  637,  395,  537,  861,  631,  533,  519,  -35,  519,
 /*   140 */   542,  860,  685,  638,  503,  -35,  -35,  -35,  346,  349,
 /*   150 */   -35,  -35,  -35,  -35,  170,  -35,  196,  -35,  635,  636,
 /*   160 */   604,  604,  604,  604,  604,  618,  599,  642,  604,  599,
 /*   170 */   599,  604,  604,  604,  618,  604,  604,  604,  604,  604,
 /*   180 */   599,  604,  604,  599,  604,  604,  604,  604,  634,  624,
 /*   190 */   618,  624,  634,  618,  624,  617,   43,  -64,  159,   21,
 /*   200 */   169,  151,  183,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, 32, ),
        /* 1 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 2 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 3 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 4 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 5 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 6 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 7 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 8 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 62, 75, ),
        /* 9 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 10 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 11 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 12 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 13 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 14 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 15 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 16 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 17 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 18 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 19 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 20 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 21 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 22 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 23 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 24 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 25 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 26 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 27 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 28 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 29 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 30 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 31 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 32 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 33 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 34 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 35 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 36 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 37 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 38 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 39 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 40 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 41 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 42 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 43 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 44 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 45 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 46 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 47 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 48 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 49 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 50 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 51 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 52 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 53 */ array(1, 16, 22, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 54 */ array(1, 16, 22, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 55 */ array(1, 16, 22, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 56 */ array(1, 22, 27, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 57 */ array(1, 22, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 58 */ array(1, 22, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 59 */ array(1, 22, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 60 */ array(1, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 61 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 62 */ array(1, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 63 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 64 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 65 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, ),
        /* 66 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 67 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 68 */ array(1, 29, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 69 */ array(1, 24, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 70 */ array(1, 2, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 71 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 72 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 73 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 74 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 75 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 76 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 77 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 78 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 79 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 80 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 81 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 82 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 83 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 84 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 85 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 86 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 87 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 88 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 89 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 90 */ array(37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 91 */ array(37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 92 */ array(1, 16, 20, 22, 35, 58, ),
        /* 93 */ array(1, 16, 22, 51, ),
        /* 94 */ array(1, 22, ),
        /* 95 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, 32, ),
        /* 96 */ array(10, 15, 21, 23, 28, 31, 32, 75, 76, 77, ),
        /* 97 */ array(15, 18, 22, 30, ),
        /* 98 */ array(15, 18, 22, 30, ),
        /* 99 */ array(15, 18, 22, ),
        /* 100 */ array(15, 18, 22, ),
        /* 101 */ array(20, 56, 61, ),
        /* 102 */ array(1, 16, 22, ),
        /* 103 */ array(17, 18, 60, ),
        /* 104 */ array(1, 22, ),
        /* 105 */ array(17, 35, ),
        /* 106 */ array(1, 22, ),
        /* 107 */ array(10, 15, 21, 23, 28, 31, 32, 75, 76, 77, ),
        /* 108 */ array(4, 5, 6, 7, 8, 12, 13, 14, ),
        /* 109 */ array(1, 16, 22, 29, 51, ),
        /* 110 */ array(15, 18, 19, 59, ),
        /* 111 */ array(1, 16, 22, 51, ),
        /* 112 */ array(1, 16, 22, 51, ),
        /* 113 */ array(15, 18, 19, 25, ),
        /* 114 */ array(15, 18, 19, ),
        /* 115 */ array(15, 18, 59, ),
        /* 116 */ array(19, 20, 58, ),
        /* 117 */ array(1, 30, 51, ),
        /* 118 */ array(16, 22, 25, ),
        /* 119 */ array(19, 20, 58, ),
        /* 120 */ array(16, 22, 25, ),
        /* 121 */ array(1, 16, 20, ),
        /* 122 */ array(1, 16, 51, ),
        /* 123 */ array(17, 18, ),
        /* 124 */ array(20, 58, ),
        /* 125 */ array(15, 18, ),
        /* 126 */ array(17, 35, ),
        /* 127 */ array(15, 18, ),
        /* 128 */ array(15, 18, ),
        /* 129 */ array(1, 16, ),
        /* 130 */ array(15, 18, ),
        /* 131 */ array(15, 18, ),
        /* 132 */ array(15, 18, ),
        /* 133 */ array(17, 35, ),
        /* 134 */ array(15, 18, ),
        /* 135 */ array(15, 18, ),
        /* 136 */ array(16, 22, ),
        /* 137 */ array(15, 18, ),
        /* 138 */ array(1, 51, ),
        /* 139 */ array(15, 18, ),
        /* 140 */ array(17, 18, ),
        /* 141 */ array(15, 18, ),
        /* 142 */ array(15, 18, ),
        /* 143 */ array(15, 18, ),
        /* 144 */ array(15, 18, ),
        /* 145 */ array(1, ),
        /* 146 */ array(1, ),
        /* 147 */ array(1, ),
        /* 148 */ array(22, ),
        /* 149 */ array(22, ),
        /* 150 */ array(1, ),
        /* 151 */ array(1, ),
        /* 152 */ array(1, ),
        /* 153 */ array(1, ),
        /* 154 */ array(20, ),
        /* 155 */ array(1, ),
        /* 156 */ array(20, ),
        /* 157 */ array(),
        /* 158 */ array(15, 18, 59, ),
        /* 159 */ array(15, 17, 18, ),
        /* 160 */ array(16, 22, ),
        /* 161 */ array(16, 22, ),
        /* 162 */ array(16, 22, ),
        /* 163 */ array(16, 22, ),
        /* 164 */ array(16, 22, ),
        /* 165 */ array(1, 16, ),
        /* 166 */ array(56, 61, ),
        /* 167 */ array(15, 35, ),
        /* 168 */ array(16, 22, ),
        /* 169 */ array(56, 61, ),
        /* 170 */ array(56, 61, ),
        /* 171 */ array(16, 22, ),
        /* 172 */ array(16, 22, ),
        /* 173 */ array(16, 22, ),
        /* 174 */ array(1, 16, ),
        /* 175 */ array(16, 22, ),
        /* 176 */ array(16, 22, ),
        /* 177 */ array(16, 22, ),
        /* 178 */ array(16, 22, ),
        /* 179 */ array(16, 22, ),
        /* 180 */ array(56, 61, ),
        /* 181 */ array(16, 22, ),
        /* 182 */ array(16, 22, ),
        /* 183 */ array(56, 61, ),
        /* 184 */ array(16, 22, ),
        /* 185 */ array(16, 22, ),
        /* 186 */ array(16, 22, ),
        /* 187 */ array(16, 22, ),
        /* 188 */ array(2, ),
        /* 189 */ array(20, ),
        /* 190 */ array(1, ),
        /* 191 */ array(20, ),
        /* 192 */ array(2, ),
        /* 193 */ array(1, ),
        /* 194 */ array(20, ),
        /* 195 */ array(35, ),
        /* 196 */ array(13, ),
        /* 197 */ array(22, ),
        /* 198 */ array(22, ),
        /* 199 */ array(),
        /* 200 */ array(),
        /* 201 */ array(),
        /* 202 */ array(),
        /* 203 */ array(16, 22, 24, 26, 27, 29, 34, 35, 36, 51, 58, 62, 76, ),
        /* 204 */ array(16, 19, 22, 35, 58, ),
        /* 205 */ array(15, 17, 18, 33, ),
        /* 206 */ array(16, 22, 35, 58, ),
        /* 207 */ array(35, 56, 58, 62, ),
        /* 208 */ array(30, 35, 58, ),
        /* 209 */ array(35, 58, ),
        /* 210 */ array(35, 58, ),
        /* 211 */ array(34, 36, ),
        /* 212 */ array(2, 19, ),
        /* 213 */ array(25, 76, ),
        /* 214 */ array(34, 36, ),
        /* 215 */ array(19, 56, ),
        /* 216 */ array(24, 34, ),
        /* 217 */ array(34, 62, ),
        /* 218 */ array(18, 59, ),
        /* 219 */ array(34, 36, ),
        /* 220 */ array(18, ),
        /* 221 */ array(60, ),
        /* 222 */ array(22, ),
        /* 223 */ array(18, ),
        /* 224 */ array(17, ),
        /* 225 */ array(18, ),
        /* 226 */ array(18, ),
        /* 227 */ array(17, ),
        /* 228 */ array(33, ),
        /* 229 */ array(62, ),
        /* 230 */ array(18, ),
        /* 231 */ array(18, ),
        /* 232 */ array(56, ),
        /* 233 */ array(2, ),
        /* 234 */ array(18, ),
        /* 235 */ array(19, ),
        /* 236 */ array(2, ),
        /* 237 */ array(22, ),
        /* 238 */ array(35, ),
        /* 239 */ array(18, ),
        /* 240 */ array(36, ),
        /* 241 */ array(35, ),
        /* 242 */ array(18, ),
        /* 243 */ array(17, ),
        /* 244 */ array(17, ),
        /* 245 */ array(60, ),
        /* 246 */ array(17, ),
        /* 247 */ array(33, ),
        /* 248 */ array(25, ),
        /* 249 */ array(26, ),
        /* 250 */ array(52, ),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
);
    static public $yy_default = array(
 /*     0 */   386,  565,  582,  536,  582,  536,  536,  582,  582,  582,
 /*    10 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    20 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    30 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    40 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    50 */   582,  582,  582,  582,  582,  582,  444,  444,  444,  444,
 /*    60 */   582,  582,  582,  582,  582,  582,  582,  582,  449,  582,
 /*    70 */   582,  446,  535,  428,  534,  566,  567,  478,  477,  468,
 /*    80 */   465,  449,  568,  455,  469,  474,  473,  470,  454,  451,
 /*    90 */   482,  481,  493,  457,  444,  383,  582,  444,  444,  444,
 /*   100 */   444,  548,  464,  582,  444,  582,  444,  582,  582,  457,
 /*   110 */   509,  457,  457,  582,  509,  509,  502,  457,  483,  502,
 /*   120 */   483,  582,  457,  582,  502,  582,  582,  582,  582,  582,
 /*   130 */   582,  582,  509,  582,  582,  582,  582,  582,  457,  582,
 /*   140 */   582,  582,  582,  582,  582,  480,  461,  484,  444,  444,
 /*   150 */   486,  485,  462,  467,  502,  460,  545,  543,  510,  582,
 /*   160 */   582,  582,  582,  582,  582,  582,  527,  509,  582,  526,
 /*   170 */   529,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*   180 */   507,  582,  582,  528,  582,  582,  582,  582,  537,  523,
 /*   190 */   501,  546,  538,  464,  549,  509,  401,  581,  581,  542,
 /*   200 */   509,  509,  542,  459,  493,  582,  493,  493,  493,  493,
 /*   210 */   479,  582,  521,  483,  582,  489,  582,  582,  582,  582,
 /*   220 */   582,  582,  582,  582,  582,  582,  582,  582,  491,  582,
 /*   230 */   582,  582,  489,  521,  582,  582,  521,  582,  547,  582,
 /*   240 */   582,  521,  582,  582,  582,  582,  582,  582,  483,  452,
 /*   250 */   495,  544,  514,  516,  515,  518,  495,  531,  532,  409,
 /*   260 */   395,  431,  394,  425,  396,  430,  398,  456,  397,  426,
 /*   270 */   393,  387,  385,  384,  388,  389,  392,  391,  390,  399,
 /*   280 */   400,  435,  442,  436,  410,  423,  424,  441,  443,  522,
 /*   290 */   408,  407,  404,  403,  402,  405,  453,  429,  580,  406,
 /*   300 */   440,  573,  558,  559,  560,  561,  557,  556,  553,  554,
 /*   310 */   555,  463,  492,  540,  539,  411,  525,  488,  490,  500,
 /*   320 */   504,  552,  551,  508,  503,  459,  466,  499,  496,  497,
 /*   330 */   511,  471,  472,  498,  513,  550,  512,  476,  519,  458,
 /*   340 */   475,  576,  487,  575,  578,  579,  572,  574,  494,  434,
 /*   350 */   570,  571,  433,  562,  530,  505,  506,  427,  533,  564,
 /*   360 */   563,  432,  569,  421,  415,  416,  439,  414,  541,  412,
 /*   370 */   413,  577,  438,  417,  521,  422,  520,  420,  437,  524,
 /*   380 */   418,  419,  517,
);
    const YYNOCODE = 121;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 383;
    const YYNRULE = 199;
    const YYERRORSYMBOL = 78;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'VERT',          'COLON',         'COMMENT',     
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',   
  'FAKEPHPSTARTTAG',  'XMLTAG',        'OTHER',         'LINEBREAK',   
  'LITERALSTART',  'LITERALEND',    'LITERAL',       'LDEL',        
  'RDEL',          'DOLLAR',        'ID',            'EQUAL',       
  'PTR',           'LDELIF',        'SPACE',         'LDELFOR',     
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',        
  'LDELFOREACH',   'AS',            'APTR',          'SMARTYBLOCKCHILD',
  'LDELSLASH',     'INTEGER',       'COMMA',         'OPENP',       
  'CLOSEP',        'MATH',          'UNIMATH',       'ANDSYM',      
  'ISIN',          'ISDIVBY',       'ISNOTDIVBY',    'ISEVEN',      
  'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY',   'ISODD',       
  'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',    'INSTANCEOF',  
  'QMARK',         'NOT',           'TYPECAST',      'HEX',         
  'DOT',           'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',          
  'HATCH',         'OPENB',         'CLOSEB',        'EQUALS',      
  'NOTEQUALS',     'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',
  'LESSEQUAL',     'IDENTITY',      'NONEIDENTITY',  'MOD',         
  'LAND',          'LOR',           'LXOR',          'QUOTE',       
  'BACKTICK',      'DOLLARID',      'error',         'start',       
  'template',      'template_element',  'smartytag',     'literal',     
  'literal_elements',  'literal_element',  'value',         'attributes',  
  'variable',      'expr',          'modifierlist',  'varindexed',  
  'statement',     'statements',    'optspace',      'varvar',      
  'foraction',     'attribute',     'ternary',       'array',       
  'ifcond',        'lop',           'function',      'doublequoted_with_quotes',
  'static_class_access',  'object',        'arrayindex',    'indexdef',    
  'varvarele',     'objectchain',   'objectelement',  'method',      
  'params',        'modifier',      'modparameters',  'modparameter',
  'arrayelements',  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= OTHER",
 /*  14 */ "template_element ::= LINEBREAK",
 /*  15 */ "literal ::= LITERALSTART LITERALEND",
 /*  16 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  17 */ "literal_elements ::= literal_elements literal_element",
 /*  18 */ "literal_elements ::=",
 /*  19 */ "literal_element ::= literal",
 /*  20 */ "literal_element ::= LITERAL",
 /*  21 */ "literal_element ::= PHPSTARTTAG",
 /*  22 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  23 */ "literal_element ::= PHPENDTAG",
 /*  24 */ "literal_element ::= ASPSTARTTAG",
 /*  25 */ "literal_element ::= ASPENDTAG",
 /*  26 */ "smartytag ::= LDEL value RDEL",
 /*  27 */ "smartytag ::= LDEL value attributes RDEL",
 /*  28 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  29 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  31 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  34 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID RDEL",
 /*  37 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  38 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  40 */ "smartytag ::= LDELIF SPACE expr RDEL",
 /*  41 */ "smartytag ::= LDELIF SPACE expr attributes RDEL",
 /*  42 */ "smartytag ::= LDELIF SPACE statement RDEL",
 /*  43 */ "smartytag ::= LDELIF SPACE statement attributes RDEL",
 /*  44 */ "smartytag ::= LDELFOR SPACE statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  45 */ "foraction ::= EQUAL expr",
 /*  46 */ "foraction ::= INCDEC",
 /*  47 */ "smartytag ::= LDELFOR SPACE statement TO expr attributes RDEL",
 /*  48 */ "smartytag ::= LDELFOR SPACE statement TO expr STEP expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  55 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  56 */ "smartytag ::= LDELSLASH ID modifierlist RDEL",
 /*  57 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  58 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist RDEL",
 /*  59 */ "attributes ::= attributes attribute",
 /*  60 */ "attributes ::= attribute",
 /*  61 */ "attributes ::=",
 /*  62 */ "attribute ::= SPACE ID EQUAL ID",
 /*  63 */ "attribute ::= SPACE ID EQUAL expr",
 /*  64 */ "attribute ::= SPACE ID EQUAL value",
 /*  65 */ "attribute ::= SPACE ID",
 /*  66 */ "attribute ::= SPACE expr",
 /*  67 */ "attribute ::= SPACE value",
 /*  68 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  69 */ "statements ::= statement",
 /*  70 */ "statements ::= statements COMMA statement",
 /*  71 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  72 */ "statement ::= varindexed EQUAL expr",
 /*  73 */ "statement ::= OPENP statement CLOSEP",
 /*  74 */ "expr ::= value",
 /*  75 */ "expr ::= ternary",
 /*  76 */ "expr ::= DOLLAR ID COLON ID",
 /*  77 */ "expr ::= expr MATH value",
 /*  78 */ "expr ::= expr UNIMATH value",
 /*  79 */ "expr ::= expr ANDSYM value",
 /*  80 */ "expr ::= array",
 /*  81 */ "expr ::= expr modifierlist",
 /*  82 */ "expr ::= expr ifcond expr",
 /*  83 */ "expr ::= expr ISIN array",
 /*  84 */ "expr ::= expr ISIN value",
 /*  85 */ "expr ::= expr lop expr",
 /*  86 */ "expr ::= expr ISDIVBY expr",
 /*  87 */ "expr ::= expr ISNOTDIVBY expr",
 /*  88 */ "expr ::= expr ISEVEN",
 /*  89 */ "expr ::= expr ISNOTEVEN",
 /*  90 */ "expr ::= expr ISEVENBY expr",
 /*  91 */ "expr ::= expr ISNOTEVENBY expr",
 /*  92 */ "expr ::= expr ISODD",
 /*  93 */ "expr ::= expr ISNOTODD",
 /*  94 */ "expr ::= expr ISODDBY expr",
 /*  95 */ "expr ::= expr ISNOTODDBY expr",
 /*  96 */ "expr ::= value INSTANCEOF ID",
 /*  97 */ "expr ::= value INSTANCEOF value",
 /*  98 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /*  99 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 100 */ "value ::= variable",
 /* 101 */ "value ::= UNIMATH value",
 /* 102 */ "value ::= NOT value",
 /* 103 */ "value ::= TYPECAST value",
 /* 104 */ "value ::= variable INCDEC",
 /* 105 */ "value ::= HEX",
 /* 106 */ "value ::= INTEGER",
 /* 107 */ "value ::= INTEGER DOT INTEGER",
 /* 108 */ "value ::= INTEGER DOT",
 /* 109 */ "value ::= DOT INTEGER",
 /* 110 */ "value ::= ID",
 /* 111 */ "value ::= function",
 /* 112 */ "value ::= OPENP expr CLOSEP",
 /* 113 */ "value ::= SINGLEQUOTESTRING",
 /* 114 */ "value ::= doublequoted_with_quotes",
 /* 115 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 116 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 117 */ "value ::= smartytag",
 /* 118 */ "value ::= value modifierlist",
 /* 119 */ "variable ::= varindexed",
 /* 120 */ "variable ::= DOLLAR varvar AT ID",
 /* 121 */ "variable ::= object",
 /* 122 */ "variable ::= HATCH ID HATCH",
 /* 123 */ "variable ::= HATCH variable HATCH",
 /* 124 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 125 */ "arrayindex ::= arrayindex indexdef",
 /* 126 */ "arrayindex ::=",
 /* 127 */ "indexdef ::= DOT DOLLAR varvar",
 /* 128 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 129 */ "indexdef ::= DOT ID",
 /* 130 */ "indexdef ::= DOT INTEGER",
 /* 131 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 132 */ "indexdef ::= OPENB ID CLOSEB",
 /* 133 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 134 */ "indexdef ::= OPENB expr CLOSEB",
 /* 135 */ "indexdef ::= OPENB CLOSEB",
 /* 136 */ "varvar ::= varvarele",
 /* 137 */ "varvar ::= varvar varvarele",
 /* 138 */ "varvarele ::= ID",
 /* 139 */ "varvarele ::= LDEL expr RDEL",
 /* 140 */ "object ::= varindexed objectchain",
 /* 141 */ "objectchain ::= objectelement",
 /* 142 */ "objectchain ::= objectchain objectelement",
 /* 143 */ "objectelement ::= PTR ID arrayindex",
 /* 144 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 145 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 146 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 147 */ "objectelement ::= PTR method",
 /* 148 */ "function ::= ID OPENP params CLOSEP",
 /* 149 */ "method ::= ID OPENP params CLOSEP",
 /* 150 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 151 */ "params ::= params COMMA expr",
 /* 152 */ "params ::= expr",
 /* 153 */ "params ::=",
 /* 154 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 155 */ "modifierlist ::= modifier modparameters",
 /* 156 */ "modifier ::= VERT AT ID",
 /* 157 */ "modifier ::= VERT ID",
 /* 158 */ "modparameters ::= modparameters modparameter",
 /* 159 */ "modparameters ::=",
 /* 160 */ "modparameter ::= COLON value",
 /* 161 */ "modparameter ::= COLON array",
 /* 162 */ "static_class_access ::= method",
 /* 163 */ "static_class_access ::= method objectchain",
 /* 164 */ "static_class_access ::= ID",
 /* 165 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 166 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 167 */ "ifcond ::= EQUALS",
 /* 168 */ "ifcond ::= NOTEQUALS",
 /* 169 */ "ifcond ::= GREATERTHAN",
 /* 170 */ "ifcond ::= LESSTHAN",
 /* 171 */ "ifcond ::= GREATEREQUAL",
 /* 172 */ "ifcond ::= LESSEQUAL",
 /* 173 */ "ifcond ::= IDENTITY",
 /* 174 */ "ifcond ::= NONEIDENTITY",
 /* 175 */ "ifcond ::= MOD",
 /* 176 */ "lop ::= LAND",
 /* 177 */ "lop ::= LOR",
 /* 178 */ "lop ::= LXOR",
 /* 179 */ "array ::= OPENB arrayelements CLOSEB",
 /* 180 */ "arrayelements ::= arrayelement",
 /* 181 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 182 */ "arrayelements ::=",
 /* 183 */ "arrayelement ::= value APTR expr",
 /* 184 */ "arrayelement ::= ID APTR expr",
 /* 185 */ "arrayelement ::= expr",
 /* 186 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 187 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 188 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 189 */ "doublequoted ::= doublequotedcontent",
 /* 190 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 191 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 192 */ "doublequotedcontent ::= DOLLARID",
 /* 193 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 194 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 195 */ "doublequotedcontent ::= smartytag",
 /* 196 */ "doublequotedcontent ::= OTHER",
 /* 197 */ "optspace ::= SPACE",
 /* 198 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 73 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1731 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 2 ),
  array( 'lhs' => 80, 'rhs' => 0 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 0 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 13 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 9 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 0 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 98, 'rhs' => 8 ),
  array( 'lhs' => 98, 'rhs' => 7 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 4 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 0 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 4 ),
  array( 'lhs' => 110, 'rhs' => 5 ),
  array( 'lhs' => 110, 'rhs' => 6 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 0 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 0 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 0 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        18 => 15,
        16 => 16,
        17 => 17,
        101 => 17,
        103 => 17,
        104 => 17,
        163 => 17,
        19 => 19,
        20 => 19,
        74 => 19,
        75 => 19,
        100 => 19,
        105 => 19,
        106 => 19,
        111 => 19,
        113 => 19,
        114 => 19,
        121 => 19,
        162 => 19,
        180 => 19,
        21 => 21,
        22 => 21,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 27,
        30 => 27,
        29 => 29,
        31 => 31,
        32 => 31,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        42 => 40,
        41 => 41,
        43 => 41,
        44 => 44,
        45 => 45,
        46 => 46,
        66 => 46,
        67 => 46,
        164 => 46,
        185 => 46,
        47 => 47,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        69 => 60,
        152 => 60,
        156 => 60,
        61 => 61,
        153 => 61,
        62 => 62,
        63 => 63,
        64 => 63,
        65 => 65,
        68 => 68,
        70 => 70,
        71 => 71,
        72 => 71,
        73 => 73,
        76 => 76,
        77 => 77,
        78 => 77,
        79 => 77,
        80 => 80,
        136 => 80,
        197 => 80,
        81 => 81,
        118 => 81,
        82 => 82,
        85 => 82,
        96 => 82,
        83 => 83,
        84 => 84,
        86 => 86,
        87 => 87,
        88 => 88,
        93 => 88,
        89 => 89,
        92 => 89,
        90 => 90,
        95 => 90,
        91 => 91,
        94 => 91,
        97 => 97,
        98 => 98,
        99 => 99,
        102 => 102,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        112 => 112,
        115 => 115,
        116 => 116,
        117 => 117,
        119 => 119,
        120 => 120,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        134 => 131,
        132 => 132,
        133 => 133,
        135 => 135,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        154 => 154,
        155 => 155,
        157 => 157,
        158 => 158,
        159 => 159,
        160 => 160,
        161 => 160,
        165 => 165,
        166 => 166,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        181 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        186 => 186,
        187 => 187,
        188 => 188,
        189 => 189,
        190 => 190,
        191 => 190,
        193 => 190,
        192 => 192,
        194 => 194,
        195 => 195,
        196 => 196,
        198 => 198,
    );
#line 84 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->root_buffer->to_smarty_php();     }
#line 2155 "smarty_internal_templateparser.php"
#line 90 "smarty_internal_templateparser.y"
    function yy_r1(){ $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);     }
#line 2158 "smarty_internal_templateparser.php"
#line 102 "smarty_internal_templateparser.y"
    function yy_r4(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
                                         } else { 
                                           $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
                                         }  
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 2170 "smarty_internal_templateparser.php"
#line 114 "smarty_internal_templateparser.y"
    function yy_r5(){ $this->_retvalue = new _smarty_tag($this, '');    }
#line 2173 "smarty_internal_templateparser.php"
#line 117 "smarty_internal_templateparser.y"
    function yy_r6(){ $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2176 "smarty_internal_templateparser.php"
#line 120 "smarty_internal_templateparser.y"
    function yy_r7(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2189 "smarty_internal_templateparser.php"
#line 132 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->is_xml) {
                                       $this->compiler->tag_nocache = true; 
                                       $this->is_xml = true; 
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true));
                                      }elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2205 "smarty_internal_templateparser.php"
#line 148 "smarty_internal_templateparser.y"
    function yy_r9(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }
                                        }
#line 2226 "smarty_internal_templateparser.php"
#line 169 "smarty_internal_templateparser.y"
    function yy_r10(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }
                                        }
#line 2247 "smarty_internal_templateparser.php"
#line 189 "smarty_internal_templateparser.y"
    function yy_r11(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     }
                                        }
#line 2255 "smarty_internal_templateparser.php"
#line 197 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->compiler->tag_nocache = true; $this->is_xml = true; $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));    }
#line 2258 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r13(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 2266 "smarty_internal_templateparser.php"
#line 206 "smarty_internal_templateparser.y"
    function yy_r14(){
                                     $this->_retvalue = new _smarty_linebreak($this, $this->yystack[$this->yyidx + 0]->minor);
                                       }
#line 2271 "smarty_internal_templateparser.php"
#line 211 "smarty_internal_templateparser.y"
    function yy_r15(){ $this->_retvalue = '';     }
#line 2274 "smarty_internal_templateparser.php"
#line 212 "smarty_internal_templateparser.y"
    function yy_r16(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2277 "smarty_internal_templateparser.php"
#line 214 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2280 "smarty_internal_templateparser.php"
#line 217 "smarty_internal_templateparser.y"
    function yy_r19(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2283 "smarty_internal_templateparser.php"
#line 219 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2286 "smarty_internal_templateparser.php"
#line 221 "smarty_internal_templateparser.y"
    function yy_r23(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2289 "smarty_internal_templateparser.php"
#line 222 "smarty_internal_templateparser.y"
    function yy_r24(){ $this->_retvalue = '<<?php ?>%';     }
#line 2292 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = '%<?php ?>>';     }
#line 2295 "smarty_internal_templateparser.php"
#line 231 "smarty_internal_templateparser.y"
    function yy_r26(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2298 "smarty_internal_templateparser.php"
#line 232 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2301 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2304 "smarty_internal_templateparser.php"
#line 242 "smarty_internal_templateparser.y"
    function yy_r31(){ $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")));    }
#line 2307 "smarty_internal_templateparser.php"
#line 244 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'")),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2310 "smarty_internal_templateparser.php"
#line 245 "smarty_internal_templateparser.y"
    function yy_r34(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>$this->yystack[$this->yyidx + -4]->minor['var'])),$this->yystack[$this->yyidx + -1]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -4]->minor['smarty_internal_index']));    }
#line 2313 "smarty_internal_templateparser.php"
#line 247 "smarty_internal_templateparser.y"
    function yy_r35(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2316 "smarty_internal_templateparser.php"
#line 248 "smarty_internal_templateparser.y"
    function yy_r36(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2319 "smarty_internal_templateparser.php"
#line 250 "smarty_internal_templateparser.y"
    function yy_r37(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2322 "smarty_internal_templateparser.php"
#line 252 "smarty_internal_templateparser.y"
    function yy_r38(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                     }
#line 2327 "smarty_internal_templateparser.php"
#line 256 "smarty_internal_templateparser.y"
    function yy_r39(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                                }
#line 2332 "smarty_internal_templateparser.php"
#line 260 "smarty_internal_templateparser.y"
    function yy_r40(){ $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2335 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r41(){ $tag = trim(substr($this->yystack[$this->yyidx + -4]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + -1]->minor,array('if condition'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2338 "smarty_internal_templateparser.php"
#line 265 "smarty_internal_templateparser.y"
    function yy_r44(){
                                                             $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -10]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -7]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),1);    }
#line 2342 "smarty_internal_templateparser.php"
#line 268 "smarty_internal_templateparser.y"
    function yy_r45(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2345 "smarty_internal_templateparser.php"
#line 269 "smarty_internal_templateparser.y"
    function yy_r46(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2348 "smarty_internal_templateparser.php"
#line 270 "smarty_internal_templateparser.y"
    function yy_r47(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -4]->minor),array('to'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2351 "smarty_internal_templateparser.php"
#line 271 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('to'=>$this->yystack[$this->yyidx + -4]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2354 "smarty_internal_templateparser.php"
#line 273 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2357 "smarty_internal_templateparser.php"
#line 275 "smarty_internal_templateparser.y"
    function yy_r50(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2361 "smarty_internal_templateparser.php"
#line 277 "smarty_internal_templateparser.y"
    function yy_r51(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2365 "smarty_internal_templateparser.php"
#line 279 "smarty_internal_templateparser.y"
    function yy_r52(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2369 "smarty_internal_templateparser.php"
#line 281 "smarty_internal_templateparser.y"
    function yy_r53(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2373 "smarty_internal_templateparser.php"
#line 285 "smarty_internal_templateparser.y"
    function yy_r54(){ $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);    }
#line 2376 "smarty_internal_templateparser.php"
#line 289 "smarty_internal_templateparser.y"
    function yy_r55(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2379 "smarty_internal_templateparser.php"
#line 291 "smarty_internal_templateparser.y"
    function yy_r56(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
                                                                                          }
#line 2383 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r57(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2386 "smarty_internal_templateparser.php"
#line 295 "smarty_internal_templateparser.y"
    function yy_r58(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2389 "smarty_internal_templateparser.php"
#line 301 "smarty_internal_templateparser.y"
    function yy_r59(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2392 "smarty_internal_templateparser.php"
#line 303 "smarty_internal_templateparser.y"
    function yy_r60(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2395 "smarty_internal_templateparser.php"
#line 305 "smarty_internal_templateparser.y"
    function yy_r61(){ $this->_retvalue = array();    }
#line 2398 "smarty_internal_templateparser.php"
#line 308 "smarty_internal_templateparser.y"
    function yy_r62(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
                                                 } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
                                                 } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
                                                 } else
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2408 "smarty_internal_templateparser.php"
#line 316 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2411 "smarty_internal_templateparser.php"
#line 318 "smarty_internal_templateparser.y"
    function yy_r65(){ $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";    }
#line 2414 "smarty_internal_templateparser.php"
#line 321 "smarty_internal_templateparser.y"
    function yy_r68(){$this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2417 "smarty_internal_templateparser.php"
#line 328 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2420 "smarty_internal_templateparser.php"
#line 330 "smarty_internal_templateparser.y"
    function yy_r71(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2423 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r73(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;    }
#line 2426 "smarty_internal_templateparser.php"
#line 343 "smarty_internal_templateparser.y"
    function yy_r76(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2429 "smarty_internal_templateparser.php"
#line 345 "smarty_internal_templateparser.y"
    function yy_r77(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2432 "smarty_internal_templateparser.php"
#line 351 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2435 "smarty_internal_templateparser.php"
#line 354 "smarty_internal_templateparser.y"
    function yy_r81(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));     }
#line 2438 "smarty_internal_templateparser.php"
#line 358 "smarty_internal_templateparser.y"
    function yy_r82(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2441 "smarty_internal_templateparser.php"
#line 359 "smarty_internal_templateparser.y"
    function yy_r83(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2444 "smarty_internal_templateparser.php"
#line 360 "smarty_internal_templateparser.y"
    function yy_r84(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2447 "smarty_internal_templateparser.php"
#line 362 "smarty_internal_templateparser.y"
    function yy_r86(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2450 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r87(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2453 "smarty_internal_templateparser.php"
#line 364 "smarty_internal_templateparser.y"
    function yy_r88(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2456 "smarty_internal_templateparser.php"
#line 365 "smarty_internal_templateparser.y"
    function yy_r89(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2459 "smarty_internal_templateparser.php"
#line 366 "smarty_internal_templateparser.y"
    function yy_r90(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2462 "smarty_internal_templateparser.php"
#line 367 "smarty_internal_templateparser.y"
    function yy_r91(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2465 "smarty_internal_templateparser.php"
#line 373 "smarty_internal_templateparser.y"
    function yy_r97(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2468 "smarty_internal_templateparser.php"
#line 379 "smarty_internal_templateparser.y"
    function yy_r98(){ $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? $_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'\')->value : '.$this->yystack[$this->yyidx + 0]->minor;  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + -2]->minor', null, true, false)->nocache;    }
#line 2471 "smarty_internal_templateparser.php"
#line 380 "smarty_internal_templateparser.y"
    function yy_r99(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2474 "smarty_internal_templateparser.php"
#line 387 "smarty_internal_templateparser.y"
    function yy_r102(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2477 "smarty_internal_templateparser.php"
#line 393 "smarty_internal_templateparser.y"
    function yy_r107(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2480 "smarty_internal_templateparser.php"
#line 394 "smarty_internal_templateparser.y"
    function yy_r108(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';     }
#line 2483 "smarty_internal_templateparser.php"
#line 395 "smarty_internal_templateparser.y"
    function yy_r109(){ $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2486 "smarty_internal_templateparser.php"
#line 397 "smarty_internal_templateparser.y"
    function yy_r110(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'true';
                               } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'false';
                               } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'null';
                               } else
                               $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2496 "smarty_internal_templateparser.php"
#line 408 "smarty_internal_templateparser.y"
    function yy_r112(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2499 "smarty_internal_templateparser.php"
#line 414 "smarty_internal_templateparser.y"
    function yy_r115(){if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
                      																				   if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
                                                                  $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
                      																				   } else {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
                                                                 } 
                                                                } else {
                                                                 $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
                                                                }
                                                                   }
#line 2511 "smarty_internal_templateparser.php"
#line 424 "smarty_internal_templateparser.y"
    function yy_r116(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2515 "smarty_internal_templateparser.php"
#line 427 "smarty_internal_templateparser.y"
    function yy_r117(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2518 "smarty_internal_templateparser.php"
#line 437 "smarty_internal_templateparser.y"
    function yy_r119(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') {
																				$smarty_var = $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
																				$this->_retvalue = $smarty_var;
                                      } else {
                                      	// used for array reset,next,prev,end,current 
                                      	$this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
                                      	$this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + 0]->minor['var']])) {
                                          $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	} else {
                                          $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	}
                                      	$this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;
                                     }
                                        }
#line 2535 "smarty_internal_templateparser.php"
#line 453 "smarty_internal_templateparser.y"
    function yy_r120(){if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + -2]->minor])) {
                                                  $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 } else {
                                                  $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 }
                                                  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2543 "smarty_internal_templateparser.php"
#line 462 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2546 "smarty_internal_templateparser.php"
#line 463 "smarty_internal_templateparser.y"
    function yy_r123(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2549 "smarty_internal_templateparser.php"
#line 466 "smarty_internal_templateparser.y"
    function yy_r124(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2552 "smarty_internal_templateparser.php"
#line 472 "smarty_internal_templateparser.y"
    function yy_r125(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2555 "smarty_internal_templateparser.php"
#line 474 "smarty_internal_templateparser.y"
    function yy_r126(){return;    }
#line 2558 "smarty_internal_templateparser.php"
#line 478 "smarty_internal_templateparser.y"
    function yy_r127(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2561 "smarty_internal_templateparser.php"
#line 479 "smarty_internal_templateparser.y"
    function yy_r128(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2564 "smarty_internal_templateparser.php"
#line 480 "smarty_internal_templateparser.y"
    function yy_r129(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2567 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r130(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2570 "smarty_internal_templateparser.php"
#line 482 "smarty_internal_templateparser.y"
    function yy_r131(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2573 "smarty_internal_templateparser.php"
#line 484 "smarty_internal_templateparser.y"
    function yy_r132(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2576 "smarty_internal_templateparser.php"
#line 485 "smarty_internal_templateparser.y"
    function yy_r133(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2579 "smarty_internal_templateparser.php"
#line 489 "smarty_internal_templateparser.y"
    function yy_r135(){$this->_retvalue = '[]';    }
#line 2582 "smarty_internal_templateparser.php"
#line 497 "smarty_internal_templateparser.y"
    function yy_r137(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2585 "smarty_internal_templateparser.php"
#line 499 "smarty_internal_templateparser.y"
    function yy_r138(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2588 "smarty_internal_templateparser.php"
#line 501 "smarty_internal_templateparser.y"
    function yy_r139(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2591 "smarty_internal_templateparser.php"
#line 506 "smarty_internal_templateparser.y"
    function yy_r140(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2595 "smarty_internal_templateparser.php"
#line 509 "smarty_internal_templateparser.y"
    function yy_r141(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2598 "smarty_internal_templateparser.php"
#line 511 "smarty_internal_templateparser.y"
    function yy_r142(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2601 "smarty_internal_templateparser.php"
#line 513 "smarty_internal_templateparser.y"
    function yy_r143(){if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									   }
                                                     $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                         }
#line 2608 "smarty_internal_templateparser.php"
#line 518 "smarty_internal_templateparser.y"
    function yy_r144(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															 }
                                                               $this->_retvalue = '->{$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor .')->value'.$this->yystack[$this->yyidx + 0]->minor.'}'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor,"'"), null, true, false)->nocache;
                                                                   }
#line 2615 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r145(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															   }
                     																						 $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                     																						    }
#line 2622 "smarty_internal_templateparser.php"
#line 528 "smarty_internal_templateparser.y"
    function yy_r146(){if ($this->security) {
                                                                         $this->compiler->trigger_template_error (self::Err2);
																															         }
                                                                       $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                                                                          }
#line 2629 "smarty_internal_templateparser.php"
#line 534 "smarty_internal_templateparser.y"
    function yy_r147(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2632 "smarty_internal_templateparser.php"
#line 540 "smarty_internal_templateparser.y"
    function yy_r148(){if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $func_name = strtolower($this->yystack[$this->yyidx + -3]->minor);
																					                if ($func_name == 'isset') {
																					                  if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
																					                   $this->compiler->trigger_template_error ('Illegal number of paramer in "isset()"');
																					                  }
																					                  $isset_par=str_replace("')->value","',null,true,false)->value",implode(',',$this->yystack[$this->yyidx + -1]->minor));
																					                  $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $isset_par .")";
																						              } elseif (in_array($func_name,array('empty','reset','current','end','prev','next'))){
																					                  if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
																					                   $this->compiler->trigger_template_error ('Illegal number of paramer in "empty()"');
																					                  }
																					                  if ($func_name == 'empty') {
																					                  	$this->_retvalue = $func_name.'('.str_replace("')->value","',null,true,false)->value",$this->yystack[$this->yyidx + -1]->minor[0]).')';
																					                  } else {
																					                  	$this->_retvalue = $func_name.'('.$this->yystack[$this->yyidx + -1]->minor[0].')';
																					                  }
																					                } else {
																					                  $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
																					                }
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                     }
                                                        }
#line 2660 "smarty_internal_templateparser.php"
#line 570 "smarty_internal_templateparser.y"
    function yy_r149(){if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									 }
                                                   $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
                                                      }
#line 2667 "smarty_internal_templateparser.php"
#line 575 "smarty_internal_templateparser.y"
    function yy_r150(){if ($this->security) {
                                                              $this->compiler->trigger_template_error (self::Err2);
																													 }
                                                           $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
                                                              }
#line 2674 "smarty_internal_templateparser.php"
#line 583 "smarty_internal_templateparser.y"
    function yy_r151(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));    }
#line 2677 "smarty_internal_templateparser.php"
#line 592 "smarty_internal_templateparser.y"
    function yy_r154(){$this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));    }
#line 2680 "smarty_internal_templateparser.php"
#line 593 "smarty_internal_templateparser.y"
    function yy_r155(){$this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));    }
#line 2683 "smarty_internal_templateparser.php"
#line 596 "smarty_internal_templateparser.y"
    function yy_r157(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2686 "smarty_internal_templateparser.php"
#line 601 "smarty_internal_templateparser.y"
    function yy_r158(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2689 "smarty_internal_templateparser.php"
#line 603 "smarty_internal_templateparser.y"
    function yy_r159(){$this->_retvalue = array();    }
#line 2692 "smarty_internal_templateparser.php"
#line 605 "smarty_internal_templateparser.y"
    function yy_r160(){$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2695 "smarty_internal_templateparser.php"
#line 615 "smarty_internal_templateparser.y"
    function yy_r165(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2698 "smarty_internal_templateparser.php"
#line 617 "smarty_internal_templateparser.y"
    function yy_r166(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2701 "smarty_internal_templateparser.php"
#line 626 "smarty_internal_templateparser.y"
    function yy_r167(){$this->_retvalue = '==';    }
#line 2704 "smarty_internal_templateparser.php"
#line 627 "smarty_internal_templateparser.y"
    function yy_r168(){$this->_retvalue = '!=';    }
#line 2707 "smarty_internal_templateparser.php"
#line 628 "smarty_internal_templateparser.y"
    function yy_r169(){$this->_retvalue = '>';    }
#line 2710 "smarty_internal_templateparser.php"
#line 629 "smarty_internal_templateparser.y"
    function yy_r170(){$this->_retvalue = '<';    }
#line 2713 "smarty_internal_templateparser.php"
#line 630 "smarty_internal_templateparser.y"
    function yy_r171(){$this->_retvalue = '>=';    }
#line 2716 "smarty_internal_templateparser.php"
#line 631 "smarty_internal_templateparser.y"
    function yy_r172(){$this->_retvalue = '<=';    }
#line 2719 "smarty_internal_templateparser.php"
#line 632 "smarty_internal_templateparser.y"
    function yy_r173(){$this->_retvalue = '===';    }
#line 2722 "smarty_internal_templateparser.php"
#line 633 "smarty_internal_templateparser.y"
    function yy_r174(){$this->_retvalue = '!==';    }
#line 2725 "smarty_internal_templateparser.php"
#line 634 "smarty_internal_templateparser.y"
    function yy_r175(){$this->_retvalue = '%';    }
#line 2728 "smarty_internal_templateparser.php"
#line 636 "smarty_internal_templateparser.y"
    function yy_r176(){$this->_retvalue = '&&';    }
#line 2731 "smarty_internal_templateparser.php"
#line 637 "smarty_internal_templateparser.y"
    function yy_r177(){$this->_retvalue = '||';    }
#line 2734 "smarty_internal_templateparser.php"
#line 638 "smarty_internal_templateparser.y"
    function yy_r178(){$this->_retvalue = ' XOR ';    }
#line 2737 "smarty_internal_templateparser.php"
#line 643 "smarty_internal_templateparser.y"
    function yy_r179(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2740 "smarty_internal_templateparser.php"
#line 645 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2743 "smarty_internal_templateparser.php"
#line 646 "smarty_internal_templateparser.y"
    function yy_r182(){ return;     }
#line 2746 "smarty_internal_templateparser.php"
#line 647 "smarty_internal_templateparser.y"
    function yy_r183(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2749 "smarty_internal_templateparser.php"
#line 648 "smarty_internal_templateparser.y"
    function yy_r184(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2752 "smarty_internal_templateparser.php"
#line 655 "smarty_internal_templateparser.y"
    function yy_r186(){ $this->_retvalue = "''";     }
#line 2755 "smarty_internal_templateparser.php"
#line 656 "smarty_internal_templateparser.y"
    function yy_r187(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2758 "smarty_internal_templateparser.php"
#line 658 "smarty_internal_templateparser.y"
    function yy_r188(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2761 "smarty_internal_templateparser.php"
#line 659 "smarty_internal_templateparser.y"
    function yy_r189(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2764 "smarty_internal_templateparser.php"
#line 661 "smarty_internal_templateparser.y"
    function yy_r190(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2767 "smarty_internal_templateparser.php"
#line 663 "smarty_internal_templateparser.y"
    function yy_r192(){if (isset($this->compiler->local_var["'".substr($this->yystack[$this->yyidx + 0]->minor,1)."'"])) {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
                                                      } else {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
                                                      }
                                                      $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2776 "smarty_internal_templateparser.php"
#line 671 "smarty_internal_templateparser.y"
    function yy_r194(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2779 "smarty_internal_templateparser.php"
#line 672 "smarty_internal_templateparser.y"
    function yy_r195(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2784 "smarty_internal_templateparser.php"
#line 675 "smarty_internal_templateparser.y"
    function yy_r196(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2787 "smarty_internal_templateparser.php"
#line 682 "smarty_internal_templateparser.y"
    function yy_r198(){$this->_retvalue = '';    }
#line 2790 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 66 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2853 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 58 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2871 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>